
function cleanText(text) {
  return text
    .replace(/\n(&nbsp;){2,} (?!\S+:)(?=\S+)/g, "\t\t")
    // .replace(/(?=\S):/g, ":\t")
    .replace(/(&nbsp;){2,} /g, "\t")
    .replace(/(&nbsp;)/g, "")
    .replace(/\n\n/g, "\n")
    .replace(/\n\t\t/g, "\n\t")
    .replace(":\s", ":\t");
}

document.addEventListener("paste", event => {
  var clipboardText = event.clipboardData.getData("text/html");
  // console.log(clipboardText);
  var frag = new DOMParser().parseFromString(clipboardText, "text/html");
  var $body = $(frag.body);

  // Word likes to throw in line breaks for no reason
  $body
    .find("p,span")
    .each((i, ele) => (ele.innerHTML = ele.innerHTML.replaceAll("\n", " ")));
  var cleaned = $body
    .find("p,span")
      .contents()
      .unwrap()
      .end()
    .end()
    .find("b,i")
      .removeAttr("style")
    .end()
    .find("a")
      .remove()
    .end()
    .find("div")
      .remove()
    .end()
    .html()
    .replace(/<\/?o:p[^>]*>/g, "")
    .replace(/(<!--EndFragment-->)|(<!--StartFragment-->)/g, "")
    .trim();

  $("#preview")
    .val(cleanText(cleaned))
    .trigger("change");
});

$("#download-btn").on("click", function() {
  var scriptText = $("#preview").val();
  var scriptName = scriptText.match(/(.+)(?=\n)/i);
  scriptName = scriptName ? scriptName[0] : "parsed script";

  download(scriptName + ".txt", scriptText);
});

// Source: https://jsfiddle.net/ourcodeworld/rce6nn3z/2/
function download(filename, text) {
  var element = document.createElement("a");
  element.setAttribute(
    "href",
    "data:text/plain;charset=utf-8," + encodeURIComponent(text)
  );
  element.setAttribute("download", filename);

  element.style.display = "none";
  document.body.appendChild(element);

  element.click();

  document.body.removeChild(element);
}
